<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-4 shadow-sm p-3 rounded bg-white">Daily Routines</h2>

    <div class="row">
        <?php $__empty_1 = true; $__currentLoopData = $dailyRoutines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $routine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-4 mb-4">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title"><?php echo e($routine->title); ?></h5>
                        <p class="card-text"><?php echo e($routine->description); ?></p>
                        <p class="card-text"><strong>Days:</strong> <?php echo e(implode(', ', json_decode($routine->days, true) ?? [])); ?></p>
                        <p class="card-text"><strong>Time:</strong> <?php echo e($routine->start_time); ?> - <?php echo e($routine->end_time); ?></p>
                        <div class="d-flex justify-content-between">
                            <a href="<?php echo e(route('routines.edit', $routine->id)); ?>" class="btn btn-warning"><i class="bi bi-pencil"></i></a>
                            <form action="<?php echo e(route('routines.destroy', $routine->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this routine?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger"><i class="bi bi-trash"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p class="text-center">No daily routines found.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\Task-Manager\resources\views/routines/daily.blade.php ENDPATH**/ ?>