<?php $__env->startSection('content'); ?>
    <div class="container">
        <h2 class="mb-4 shadow-sm p-3 rounded bg-white">Edit File</h2>
        <div class="card border-0 shadow-sm m-auto" style="max-width: 600px;">
            <div class="card-body">
                <form action="<?php echo e(route('files.update', $file->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="mb-3">
                        <label for="name" class="form-label">File Name</label>
                        <input type="text" name="name" id="name" class="form-control" value="<?php echo e($file->name); ?>"
                            required>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label for="file" class="form-label">Choose File (Leave blank to keep current file)</label>
                        <input type="file" name="file" id="file" class="form-control">
                        <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label for="type" class="form-label">File Type</label>
                        <select name="type" id="type" class="form-control" required>
                            <option value="project" <?php echo e($file->type == 'project' ? 'selected' : ''); ?>>Project</option>
                            <option value="docs" <?php echo e($file->type == 'docs' ? 'selected' : ''); ?>>Docs</option>
                            <option value="txt" <?php echo e($file->type == 'txt' ? 'selected' : ''); ?>>Text</option>
                            <option value="code" <?php echo e($file->type == 'code' ? 'selected' : ''); ?>>Code</option>
                            <option value="image" <?php echo e($file->type == 'image' ? 'selected' : ''); ?>>Image</option>
                        </select>
                        <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <button type="submit" class="btn btn-primary">Update File</button>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\Task-Manager\resources\views/files/edit.blade.php ENDPATH**/ ?>