<?php
namespace App\Http\Controllers;

use App\Models\Project;
use App\Models\Task;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TaskController extends Controller
{
    public function index(Project $project)
    {
        $tasks = $project->tasks()->get()->groupBy('status');
        $users = $project->users()->get();  
        return view('tasks.index', compact('project', 'tasks', 'users'));
    }

   
    
    public function store(Request $request, Project $project)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'due_date' => 'nullable|date',
            'priority' => 'required|in:low,medium,high',
        ]);
         
        $project->tasks()->create($request->all());
        // $lastAttendance = Task:where('user_id', $user->id)
          //                          ->latest('checked_in_at')
            //                        ->first();
 //if ($lastAttendance && $lastAttendance->checked_in_at && is_null($lastAttendance->checked_out_at)) {
         //   $lastAttendance->update(['checked_out_at' => now()]);
          //  return "User {$user->name} successfully checked out.";
       // }

        return redirect()->route('projects.tasks.index', $project)->with('success', 'Task created successfully.');
    }

    public function show(Task $task)
    {
      // $request->request->add(['checked_in_at' =>  now()]);
     
       if ($task && $task->checked_in_at && is_null($task->checked_out_at)) {
        $task->update(['checked_out_at' => now()]);
        }else{
           $task->update(['checked_in_at' => now()]);
  
        }
        return view('tasks.show', compact('task'));
    }

    public function update(Request $request, Task $task)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'due_date' => 'nullable|date',
            'priority' => 'required|in:low,medium,high',
            'status' => 'required|in:to_do,in_progress,completed',
        ]);

        $task->update($request->all());

        return redirect()->route('projects.tasks.index', $task->project_id)->with('success', 'Task updated successfully.');
    }

    public function updateStatus(Request $request, Task $task)
    {
        $task->status = $request->input('status');
        $task->save();

        return response()->json(['message' => 'Task status updated successfully.']);
    }
}
