<?php
namespace App\Http\Controllers;

use App\Models\Project;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Storage;
use URL;

class ProjectController extends Controller
{
    public function index()
    {
        $projects = Auth::user()->projects()->withCount(['tasks as to_do_tasks' => function ($query) {
            $query->where('status', 'to_do');
        }, 'tasks as in_progress_tasks' => function ($query) {
            $query->where('status', 'in_progress');
        }, 'tasks as completed_tasks' => function ($query) {
            $query->where('status', 'completed');
        }])->get();
//print_r(Auth::user()->get());
        return view('projects.index', compact('projects'));
    }

    public function create()
    {
        return view('projects.create');
    }
    
     public function generateAndSave($ProjectId)
    {
          $signedUrl = URL::SignedRoute(
            'attendance.scan', // Valid for 30 minutes
            ['project' => $ProjectId]
        );

      echo  $qrCodeData = $signedUrl; // e.g., a URL, product ID, or text
        $filename = 'qrcode_' . time() . '.png';
        $path = 'qrcodes/' . $filename;

        // Generate the QR code and save it to the storage folder
        QrCode::format('png')->size(300)->generate($qrCodeData, Storage::path('public/' . $path));

        
        return $path=Storage::url('app/public/'.$path);
       // return response()->json([
       //     'message' => 'QR code generated and saved successfully.',
       //     'path' => Storage::url($path)
      //  ]);
    }
    
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date',
            'status' => 'required|in:not_started,in_progress,completed',
            'budget' => 'nullable|numeric',          
        ]);       
       //  $request->request->add(['qr_url' => $path]);

        $project=Auth::user()->projects()->create($request->all());
               $path= $this->generateAndSave($project->id);      
                $project->update(['qr_url' => $path]);
        return redirect()->route('projects.index')->with('success', 'Project created successfully.');
    }

    public function show(Project $project)
    {
        $teamMembers = $project->users()->get();
        $users = User::all();
        return view('projects.show', compact('project', 'teamMembers', 'users'));
    }
    public function edit(Project $project)
    {
        return view('projects.edit', compact('project'));
    }

    public function update(Request $request, Project $project)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date',
            'status' => 'required|in:not_started,in_progress,completed',
            'budget' => 'nullable|numeric',
        ]);

        $project->update($request->all());

        return redirect()->route('projects.index')->with('success', 'Project updated successfully.');
    }

    public function destroy(Project $project)
    {
        $project->delete();

        return redirect()->route('projects.index')->with('success', 'Project deleted successfully.');
    }

    public function addMember(Request $request)
    {
        $request->validate([
            'project_id' => 'required|exists:projects,id',
            'user_id' => 'required|exists:users,id',
        ]);
       
        $project = Project::find($request->project_id);
        $project->teamProjects()->attach($request->user_id);
        return redirect()->back()->with('success', 'User added successfully.');
    }
}
