@extends('layouts.app')
@section('title')
    Attendances 
@endsection
@section('content')
 
    <div class="container">
        <div class="d-flex justify-content-between align-items-center bg-white mb-4 shadow-sm p-3 rounded">
            <h2>Attendances</h2>
        </div>

        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif

        <div class="row">
            @foreach($attendances as $attendance)
           
                <div class="col-md-4 mb-4">
                    <div class="card">
                        <div class="card-body">
                             <h5 class="card-title">{{ $attendance->project->name }}</h5>
                             <h5 class="card-title">{{ $attendance->user->name }}</h5>
                            <h5 class="card-title">{{ $attendance->name }}</h5>
                            <p class="card-text">
                                <strong>Check in:</strong> {{($attendance->checked_in_at) }}<br>
                                <strong>Check out:</strong> {{($attendance->checked_out_at) }}<br>
                          
                        </div>
                    </div>
                </div>
            @endforeach
                {{ $attendances->links() }}

        </div>
    </div>
@endsection
