<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Project;
use App\Models\User;
use App\Models\Attendance;
use Illuminate\Support\Facades\Auth;

class AttendanceController extends Controller
{
     public function index()
    {
        $attendances = Attendance::orderBy('created_at', 'desc')->paginate(20);
        
        
//print_r(Auth::user()->get());
        return view('attendances.index', compact('attendances'));
    }
    
   public function scan(Request $request, Project $project)
    {
        if (! $request->hasValidSignature()) {
            abort(401);
        }

        $lastAttendance = Attendance::where('user_id', Auth::user()->id)
                                     -> where('project_id', $project->id)
                                    ->latest('checked_in_at')
                                    ->first();

        $user=Auth::user();
        // Check if the user is already checked in
        if ($lastAttendance && $lastAttendance->checked_in_at && is_null($lastAttendance->checked_out_at)) {
            $lastAttendance->update(['checked_out_at' => now()]);
            return "User {$user->name} successfully checked out.";
        }

        // Otherwise, create a new attendance record (check-in)
       Attendance::create([
            'user_id' =>  Auth::user()->id,
            'project_id' => $project->id,
            'checked_in_at' => now(),
        ]);

        return "User {$user->name} successfully checked in.";
    }
}
